; Adder
; Chin-Shiuh Shieh
; 2007-10-23
;
; Pin Assignment
INPUT		EQU		P1
OUTPUT		EQU		P2
AUGEND_LED	EQU		P0.0
ADDEND_LED	EQU		P0.1
SUM_LED		EQU		P0.2
CARRY_LED	EQU		P0.7
BUTTON		EQU		P3.0
; Memory Allocation
AUGEND		EQU		30h
ADDEND		EQU		31h
;
PROG	EQU		0000h
		ORG		PROG+0000h
		SJMP	START
; Interrupt Vector Table
		ORG		PROG+0003h
		LCALL	INT0_ISR
		RETI
		ORG		PROG+000Bh
		LCALL	T0_ISR
		RETI
		ORG		PROG+0013h
		LCALL	INT1_ISR
		RETI
		ORG		PROG+001Bh
		LCALL	T1_ISR
		RETI
		ORG		PROG+0023h
		LCALL	UART_ISR
		RETI
;
		ORG		PROG+0030h
START:	SETB	CARRY_LED
		SETB	SUM_LED
		CLR		AUGEND_LED
WAIT_AUGEND:
		MOV		A,INPUT
		MOV		AUGEND,A
		CPL		A
		MOV		OUTPUT,A
		JB		BUTTON,WAIT_AUGEND
WAIT_AUGEND_RELEASE:
		JNB		BUTTON,WAIT_AUGEND_RELEASE
		SETB	AUGEND_LED
		CLR		ADDEND_LED
WAIT_ADDEND:
		MOV		A,INPUT
		MOV		ADDEND,A
		CPL		A
		MOV		OUTPUT,A
		JB		BUTTON,WAIT_ADDEND
WAIT_ADDEND_RELEASE:
		JNB		BUTTON,WAIT_ADDEND_RELEASE
		SETB	ADDEND_LED
		CLR		SUM_LED
		MOV		A,AUGEND
		ADD		A,ADDEND
		CPL		A
		MOV		OUTPUT,A
		JNC		WAIT_SUM
		CLR		CARRY_LED
WAIT_SUM:
		JB		BUTTON,WAIT_SUM
WAIT_SUM_RELEASE:
		JNB		BUTTON,WAIT_SUM_RELEASE
		SJMP	START
;
INT0_ISR:
		RET
T0_ISR:
		RET
INT1_ISR:
		RET
T1_ISR:
		RET
UART_ISR:
		RET
;
		END