import socket
import threading

# Define server address and port
SERVER_HOST = '127.0.0.1'  # Change to the actual server address if needed
SERVER_PORT = 12345

# Create a TCP socket
client_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)

# Connect to the chat server
client_socket.connect((SERVER_HOST, SERVER_PORT))

def receive_messages():
    """Function to receive and print messages from the server."""
    while True:
        try:
            message = client_socket.recv(1024).decode()
            if not message:
                break
            print(message)
        except:
            print("Disconnected from server.")
            client_socket.close()
            break

# Start a thread to listen for incoming messages
threading.Thread(target=receive_messages, daemon=True).start()

print(f"Connected to chat server at {SERVER_HOST}:{SERVER_PORT}")

while True:
    message = input()
    if message.lower() == 'exit':
        break
    client_socket.send(message.encode())

client_socket.close()
print("Disconnected from chat server.")