import socket
import threading

# Define server details
HOST = '0.0.0.0'
PORT = 12345

# List to store client connections
clients = []

# Function to handle incoming messages from clients
def handle_client(client_socket, address):
    print(f"New connection from {address}")
    while True:
        try:
            message = client_socket.recv(1024).decode()
            if not message:
                break
            print(f"Received from {address}: {message}")
            broadcast(message, client_socket)
        except:
            break

    # Remove client when disconnected
    clients.remove(client_socket)
    client_socket.close()
    print(f"Connection closed: {address}")

# Function to broadcast messages to all clients
def broadcast(message, sender_socket):
    for client in clients:
        if client != sender_socket:
            try:
                client.send(message.encode())
            except:
                client.close()
                clients.remove(client)

# Create and start the server
server_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
server_socket.bind((HOST, PORT))
server_socket.listen(5)

print(f"Chat room server started on {HOST}:{PORT}")

# Accept incoming connections
while True:
    client_socket, client_address = server_socket.accept()
    clients.append(client_socket)
    threading.Thread(target=handle_client, args=(client_socket, client_address)).start()