# -*- coding: utf-8 -*-
"""Dendritic_Cell_Algorithm-01.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1AuuztKI8Jn5lm6msgB-KZq2mW6JH18np
"""

import numpy as np
import matplotlib.pyplot as plt

# Generate sample data
np.random.seed(42)
data_normal = np.random.normal(loc=0, scale=1, size=(50, 2))
data_anomalous = np.random.normal(loc=5, scale=1, size=(10, 2))
data = np.vstack((data_normal, data_anomalous))
labels = np.array([0]*50 + [1]*10)  # 0 for normal, 1 for anomalous

# Dendritic Cell Algorithm parameters
num_dcs = 30  # Number of dendritic cells
sampling_size = 5
mature_threshold = 0.5  # Threshold for decision

# Initialize DCs with random antigen from data
dc_positions = np.random.choice(len(data), size=num_dcs)
dc_states = np.zeros(num_dcs)  # 0: immature, 1: mature
cp_score = np.zeros(num_dcs)    # Cumulative 'context' score

# Function to simulate the algorithm
def dendritic_cell_algorithm(data, labels, dc_positions, sampling_size, mature_threshold):
    for i in range(100):  # Number of iterations
        for idx in range(num_dcs):
            # Sample data points
            sampled_idxs = np.random.choice(len(data), size=sampling_size)
            sampled_data = data[sampled_idxs]
            sampled_labels = labels[sampled_idxs]
            # Calculate the proportion of anomalous data in the sample
            context = np.mean(sampled_labels)
            cp_score[idx] += context
            # Update DC state
            if cp_score[idx] / (i+1) >= mature_threshold:
                dc_states[idx] = 1  # Mature

    return dc_states, cp_score

# Run the DCA
dc_states, cp_score = dendritic_cell_algorithm(data, labels, dc_positions, sampling_size, mature_threshold)

# Visualization
plt.figure(figsize=(12, 6))
plt.scatter(data[labels==0][:,0], data[labels==0][:,1], color='green', label='Normal')
plt.scatter(data[labels==1][:,0], data[labels==1][:,1], color='red', label='Anomalous')

# Plot DCs
for i, pos in enumerate(dc_positions):
    state = 'Mature' if dc_states[i] == 1 else 'Immature'
    color = 'blue' if dc_states[i] == 1 else 'gray'
    plt.scatter(data[pos][0], data[pos][1], c=color, marker='x', s=100)
    plt.text(data[pos][0], data[pos][1], f'DC {i}', fontsize=8)

plt.title('Dendritic Cell Algorithm Simulation')
plt.xlabel('Feature 1')
plt.ylabel('Feature 2')
plt.legend()
plt.show()